/*------------------------------------------------------------------------------*
 * File Name: TreeEditor.h	 													*
 * Creation: TD, CPY															*
 * Purpose: OriginC Header for OTreeEditor DLL implemented control for			*
 *			XML based Tree editing												*
 * Copyright (c) Originlab Corp.	2002, 2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE					*
 *	ML 10/10/2008 QA70-11938 GETTING_COLUMN_HEADINGS_FOR_PS						*
 *	Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID		*
 *	Kenny 04/27/2010 QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID	*
 *	Kenny 06/13/2010 ORG-305-P2 GRIDCONTROL_IS_COLLAPSED_FUNCTION_RETURN_WRONG_VALUE*
 *------------------------------------------------------------------------------*/

#ifndef _TREEEDITOR_H_
#define _TREEEDITOR_H_

//#include <Control.h>
//#include <tree.h>

#pragma dll(OTreeEditor.dll)

/// Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__

class wxGirdInterface
: public OriginObject
{
public:
	wxGirdInterface();
	
	int			AllowSelection;
	int			AllowUserResizing;
	int			AutoSizeMode;
	int			Col;
	int			Cols;
	int			ColWidthMax;
	int			ColWidthMin;
	int			ComboIndex;
	string		ComboList;
	int			Editable;
	int			Ellipsis;
	int			Enabled;
	int			ExplorerBar;
	int			ExtendLastCol;
	int			FixedCols;
	int			FixedRows;
	int			FocusRect;
	string		FormatString;
	COLORREF	GridColor;
	int			GridLines;
	int			GridLineWidth;
	int			HighLight;
	int			MergeCells;
	int			MouseCol;
	int			MouseRow;
	int			OutlineBar;
	int			OutlineCol;
	int			OwnerDraw;
	int			Redraw;
	int			Row;
	int			Rows;
	int			RowSel;
	int			SelectedRows;
	int			SelectionMode;
	string		Text;
////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////Begin Unimplemented Property///////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
/*Hong, !!!Notice:
	when u r in need to used property below, plx go to OCTreeGridControl.cpp, find the implementation of this property,
	change WARN_NEW_INTERFACE_NOT_IMPLEMENTED to WARN_OLD_INTERFACE_NOT_IMPLEMENTED and notice Hong about it,
	or better that u can implement it yourself.
*/
	string		AccessibleDescription;
	string		AccessibleName;
	int			AccessibleRole;
	string		AccessibleValue;
	int			AllowBigSelection;
	int			AllowUserFreezing;
	int			Appearance;
	int			AutoResize;
	int			AutoSearch;
	int			AutoSearchDelay;
	int			AutoSizeMouse;
	COLORREF	BackColor;
	COLORREF	BackColorAlternate;
	COLORREF	BackColorBkg;
	COLORREF	BackColorFixed;
	COLORREF	BackColorFrozen;
	COLORREF	BackColorSel;
	int			BottomRow;
	int			CellAlignment;
	COLORREF	CellBackColor;
	int			CellButtonPicture;
	int			CellChecked;
	COLORREF	CellFloodColor;
	int			CellFloodPercent;
	int			CellFontBold;
	int			CellFontItalic;
	string		CellFontName;
	int			CellFontSize;
	int			CellFontStrikethru;
	int			CellFontUnderline;
	int			CellFontWidth;
	COLORREF	CellForeColor;
	int			CellHeight;
	int			CellLeft;
	int			CellPicture;
	int			CellPictureAlignment;
	int			CellTextStyle;
	int			CellTop;
	int			CellWidth;
	int			ClientHeight;
	int			ClientWidth;
	string		Clip;
	string		ClipSeparators;
	int			ColSel;
	int			ComboCount;
	int			ComboSearch;
	string		DataMember;
	int			DataMode;
	int			DataSource;
	int			DragMode;
	string		EditMask;
	int			EditMaxLength;
	int			EditSelLength;
	int			EditSelStart;
	string		EditSelText;
	string		EditText;
	int			EditWindow;
	int			FillStyle;
	int			Flags;
	int			FlexDataSource;
	COLORREF	FloodColor;
	int			FontBold;
	int			FontItalic;
	string		FontName;
	int			FontSize;
	int			FontStrikethru;
	int			FontUnderline;
	int			FontWidth;
	COLORREF	ForeColor;
	COLORREF	ForeColorFixed;
	COLORREF	ForeColorFrozen;
	COLORREF	ForeColorSel;
	int			FrozenCols;
	int			FrozenRows;
	COLORREF	GridColorFixed;
	int			GridLinesFixed;
	int			GroupCompare;
	int			IsSearching;
	int			LeftCol;
	int			MergeCellsFixed;
	int			MergeCompare;
	int			MultiTotals;
	int			NodeClosedPicture;
	int			NodeOpenPicture;
	int			OLEDragMode;
	int			OLEDropMode;
	int			Picture;
	int			PicturesOver;
	int			PictureType;
	int			RightCol;
	int			RightToLeft;
	int			RowHeightMax;
	int			RowHeightMin;
	int			ScrollBars;
	int			ScrollTips;
	string		ScrollTipText;
	int			ScrollTrack;
	COLORREF	SheetBorder;
	int			ShowComboButton;
	int			Sort;
	int			SortAscendingPicture;
	int			SortDescendingPicture;
	int			SubtotalPosition;
	int			TabBehavior;
	int			TextStyle;
	int			TextStyleFixed;
	int			TopRow;
	COLORREF	TreeColor;
	double		Value;
	int			Version;
	int			VirtualData;
	int			WallPaper;
	int			WallPaperAlignment;
	int			WordWrap;
////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////End Unimplemented Property//////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
	
public:
	
	BOOL		AddItem(string strVals, long Row = -1);
	BOOL		RemoveItem(long Row = -1);

	void		SetCell(_VARIANT var, int setting, long r1 = -1, long c1 = -1, long r2 = -1, long c2 = -1);
	_VARIANT	GetCell(int setting, long r1, long c1, long r2 = -1, long c2 = -1);
	string		GetTextMatrix(long Row, long Col);
	void		SetTextMatrix(long Row, long Col, string strVal);

	//---	Jacky 09/03/10 IMPLEMENT_WXGRID
	string		GetColComboList(long Col);
	//---	end IMPLEMENT_WXGRID
	void		SetColComboList(long Col, string strCombo);
	
	//---	Jacky 09/03/10 IMPLEMENT_WXGRID
	//void		SetComboItem(long index, string strVal);
	//---	end IMPLEMENT_WXGRID
	string		GetComboItem(long index);

	_VARIANT	GetRowData(long Row);
	void		SetRowData(long Row, _VARIANT var);

	bool		GetIsSelected(long Row);
	void		SetIsSelected(long Row, bool bSel);

	long		FindRow(_VARIANT item, long Row = -1, long Col = -1, bool bCaseSensitive = true, bool bFullMatch = true);

	int			GetColDataType(long Col);
	void		SetColDataType(long Col, int nType);
////////////////////////////////////////////////////////////////////////////////////////
	void		ShowCell(long Row, long Col);
	void		AutoSize(long Col1, long Col2, bool bAllSameWidth = false, int nExtraSpace = 0);

	bool		GetIsSubtotal(long Row);
	void		SetIsSubtotal(long Row, bool bVal);
	long		GetRowOutlineLevel(long Row);
	void		SetRowOutlineLevel(long Row, long nLevel);

	long		GetSelectedRow(long index);

	void		SetColWidth(long Col, int nWidth);
	int			GetColWidth(long Col);
	int			GetRowHeight(long Row);
	void		SetRowHeight(long Row, int nHeight);

	bool		GetIsRowHidden(long Row);
	void		SetIsRowHidden(long Row, bool bVal);
	bool		GetIsColHidden(long Col);
	void		SetIsColHidden(long Col, bool bVal);


	void		FinishEditing(bool bFinish);

	void		SetMergeRow(long Row, bool bMerge);
	void		SetMergeCol(long Col, bool bMerge);

	void		SetColAlignment(long Col, int nMode);
	int			GetColAlignment(long Col);
	void		SetFixedAlignment(long Col, int nMode);
	int			GetFixedAlignment(long Col);
////////////////////////////////////////////////////////////////////////////////////////

	/// Kenny 04/27/2010 QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
	void		Select(long Row, long Col, long RowSel = -1, long ColSel = -1);
	void		EditCell();
	void		Outline(int nLevel);

	/// Kenny 06/13/2010 ORG-305-P2 GRIDCONTROL_IS_COLLAPSED_FUNCTION_RETURN_WRONG_VALUE
// 	bool		GetIsCollapsed(long Row);
// 	void		SetIsCollapsed(long Row, bool bSel);
	int			GetIsCollapsed(long Row);
	void		SetIsCollapsed(long Row, int nVal);
	/// End ORG-305-P2 GRIDCONTROL_IS_COLLAPSED_FUNCTION_RETURN_WRONG_VALUE

	int			GetColFormat(long Col);
	void		SetColFormat(long Col, string strFormat);
	/// End QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID

	BOOL		SetColPosition(int nCol, int nPos);
	BOOL		SetRowPosition(int nRow, int nPos);
};


class TreeGridControl : public Control
{
public:
	TreeGridControl();
	TreeGridControl(Control& ctrl);
	TreeGridControl(Window& wnd);
	
	wxGirdInterface GetGridCtrlInterface();
};


#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
/// end REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID

/**#
	Notice:
	1. When use TreeEditor attach to the Control, you need to add a string table in rc file, or it can't create correctly.
		Example: 
		uMainDlgID	= IDD_SEL_COLS_PLOTTING , uCtrlID = IDC_SELCOLS_PLOTS
		uMainDlgID	= "SCPLC" , uCtrlID	= "SCPLC.DataPlots -C(OTreeEditor)"
		In uCtriID string table, 'DataPlots' is a Control Type. More detail in OTreeEditorDll.cpp
	2. The uMainDlgID range is [100, 500], uCtrlID range need to be [6000, 12000]. For more details, see IntTree.h
*/
class TreeEditor
: public Control
{
public:
	TreeEditor();
	TreeEditor(Control& ctrl);
	TreeEditor(Window& wnd);
	
	BOOL Load(LPCSTR lpcszXMLFile);
	/**#
	Example:
		OTreeEditor	te = dlg.GetDlgItem(IDC_TREE_EDITOR);
		te.Save(GetAppPath() + "theme.xml");
	*/
	BOOL Save(LPCSTR lpcszFilename, BOOL bSelectedOnly=FALSE, BOOL bVisibleOnly=FALSE);
	
	BOOL Build(BOOL bBegin);
	
	int	AddItem(UINT nNodeType, LPCTSTR lpcszNodeLabel, LPCTSTR lpcsz=NULL, DWORD dwParam1=0L, UINT nNodeID = 0);
	BOOL SetValue(int nValue);
	BOOL SetValue(double fValue);
	BOOL SetValue(LPCSTR lpcszValue);
	
#if _OC_VER > 0x0703
	/**
			Adding or replacing a treenode inside the editor
		Parameters:
			tr = a node to be added or to be used to replace an existing node
			bReplace = ture will replace or to add depending on nRowLocation and whether the node already existed, see Remarks.
			nRowLocation = if bReplace is false, or if it is negative, then ignore, otherwise to specified the location to replace
		Remark:
			For the case where bReplace is true but nRowLocation < 0, then this function will do the following
			1. If the node does not already existed, based on a case by case condition in the nature of the tree, the node is simply added to the end
			2. If the node already existed, then we will replace it with the new node
			For the case where bReplace is true and nRowLocation is also specified, the
			1. If the node does not already existed, we simply replace the specifed row with the new node
			2. If the node already existed and is at the same row as the specified row, then we also just replace it
			3. If the node already existed but is at a different node then the specified row, we will need to first replace the specified row, then remove the conflicting one
		//------------------------
			On return *parrLayerRows receives the indices of the rows containing the layer branches of the layers
			inside which adding (or replacement) happened.
	*/
	BOOL	Add(const TreeNode &tr, BOOL bReplace, vector<uint> *parrLayerRows = NULL);
	BOOL	Add(const TreeNode &tr, vector<uint> &vPlotTypes, vector<uint> *parrLayerRows = NULL);
	
	/**#
	*/
	BOOL	GetTreeNode(TreeNode &tr, LONG nRow);
	
	/**#
	*/
	BOOL	SetTreeNode(TreeNode &tr, LONG nRow);
	
	/**#
	*/
	/// ML 10/10/2008 QA70-11938 GETTING_COLUMN_HEADINGS_FOR_PS
	///// ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
	////BOOL	BeginRowEdit(string &strGraphLayerName, string &strGraphGroupName, string &strWksPageName, string &strWksLayerName, vector<uint> &vnColDesignations, vector<string> &vstrColNames, int &nPlotType, DWORD &dwAuxTypeInfo, DWORD &dwLTPlotInfo, string &strColPattern);
	//BOOL	BeginRowEdit(string &strGraphLayerName, string &strGraphGroupName, string &strWksPageName, string &strWksLayerName, vector<uint> &vnColDesignations, vector<string> &vstrColNames, int &nPlotType, DWORD &dwAuxTypeInfo, DWORD &dwLTPlotInfo, string &strColPattern, int *pnRangeRows = NULL);
	///// end PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
	BOOL	BeginRowEdit(string &strGraphLayerName, string &strGraphGroupName, string &strWksPageName, string &strWksLayerName, vector<uint> &vnColDesignations, vector<string> &vstrColNames, int &nPlotType, DWORD &dwAuxTypeInfo, DWORD &dwLTPlotInfo, string &strColPattern, int *pnRangeRows = NULL, vector<string> &vstrColHeadings = NULL);
	/// end GETTING_COLUMN_HEADINGS_FOR_PS
	
	/**#
	*/
	BOOL	EndRowEdit();
	
	/**#
			Returns the information about the tree. The information depends on the type of the tree editor.
		Parameters:
			dwOptions = optional description of what kind of information is needed.
	*/
	DWORD	GetInfo(DWORD dwOptions = 0);
	
	/**#
	*/
	DWORD	GetRowInfo(int nRow, UINT &lParam, UINT &wParam);

	
#endif	// _OC_VER > 0x0703

	/**#
	*/
	int GetSelectedRows(vector<uint> *parrRows = NULL, BOOL bExcludeBranchNodes = FALSE);

	//properties
	DWORD 		View;
	
	TreeNode	Root;

	/**#
	get the internal property object, to be used in EditorManager class
	*/
	DWORD		GetProperty(uint nRow);

#ifdef	ORIGIN_COM_SUPPORT
	/**#
	*/
	_VARIANT GetActiveXControl();
#endif //#ifdef	ORIGIN_COM_SUPPORT

	/// Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
	wxGirdInterface GetGridCtrlInterface();
#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
	/// end REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
};

#endif //!_TREEEDITOR_H_

